-- This script demonstrates how you can over-ride the autopilot altitude dataref
-- for requesting flight level changes in X-ATC-Chatter SimpleATC

-- Without this script SimpleATC will allways monitor the dataref "sim/cockpit/autopilot/altitude" for changes
-- which can be used in conjunction with the PTT switch to request an altitude change in SimpleATC.
-- However, not every aircraft mainatins that default dataref properly. In addition some aircraft do not have an autopilot
-- that allows for the entry of a target altitude. In this situation a cockpit designer might like to use an alternate
-- mechanisim to specify a taget altitiude and initiate an ATC flight level change request

-- This script will tell SimpleATC to monitor the dataref "SRS/X-ATC-Chatter/simple_atc_altitude_change" rather than
-- "sim/cockpit/autopilot/altitude". It does this by setting "SRS/X-ATC-Chatter/use_simple_atc_altitude_change" to a 1
-- By default the script will constantly copy the value in "sim/cockpit/autopilot/altitude" to "SRS/X-ATC-Chatter/simple_atc_altitude_change" effectively
-- replicating what gets done by default. However, now you can change what the source dataref is for specific aircraft as demonstarted for the Zibo 737 below.
-- This is accomplished by simply altering the name of the source dataref inside a conditional block of code that only runs for that specific aircraft


	local USE_SIMPLE_ATC_ALTITUDE_CHANGE = dataref_table("SRS/X-ATC-Chatter/use_simple_atc_altitude_change") -- we set this to 1 to use the SimpleATC altitude change dataref_table
	local SIMPLE_ATC_ALTITUDE_CHANGE = dataref_table("SRS/X-ATC-Chatter/simple_atc_altitude_change") -- we set this to the altitude dial value on the autopilot	
	local AUTOPILOT_ALTITUDE_DATAREF_NAME = "sim/cockpit/autopilot/altitude" -- This is the default autopilot altitude
 
	if(PLANE_ICAO == "B738"  and  PLANE_TAILNUMBER == "ZB738") then
		-- The Zibo 737 will maintain the default autopilot altitude dataref however there can sometimes be a delay of a few seconds before
		-- it gets updated. The Zibo "laminar/B738/autopilot/mcp_alt_dial" seems to always be updated immediately when you change the
		-- Altitude dial on the MCP so we will use that to populate the SimpleATC dataref on each frame

		AUTOPILOT_ALTITUDE_DATAREF_NAME = "laminar/B738/autopilot/mcp_alt_dial" -- This is Zibo altitude dial

	end

	local AUTOPILOT_ALTITUDE = dataref_table(AUTOPILOT_ALTITUDE_DATAREF_NAME)	-- Create the dataref reference we plan to use


	function doAltitude()	-- 
	
		USE_SIMPLE_ATC_ALTITUDE_CHANGE[0] = 1	-- Tell SimpleATC to monitor its internal altitude dataref
		SIMPLE_ATC_ALTITUDE_CHANGE[0] = AUTOPILOT_ALTITUDE[0]	-- Set the internal altitude dataref with the one we want.
	

	end -- end 

		
		
		
	-- Update them every frame
	do_every_frame ("doAltitude()")



		
		